/*
	This is a part of the source code for Pro/DESKTOP.
	Copyright (C) 1998-1999 Parametric Technology Corporation.
	All rights reserved.
*/

//	MakePerpendicular.cpp

#include <stdafx.h>

#include "CUtility.h"
#include "CConstraints.h"
#include "CApplication.h"

HRESULT MakePerpendicular(ILine *line1, ILine *line2)
{

//	Creates a Perpendicular constraint between the two given lines

	START_METHOD("MakePerpendicular")

	HRESULT status = CONV_SUCCESS;

	IGraphicDocument *activeGraphicDoc = NULL;
	IPartDocument *activePart = NULL;
	IWorkplane *activeWorkplane = NULL;
	ISketch *activeSketch = NULL;

	status = GetActivePartWorkplaneSketch(&activePart, &activeGraphicDoc, &activeWorkplane, &activeSketch);
	CHECK_RETURN_STATUS(status)

	// Get the parent workplane of the object
	IObject *parentWorkplane = NULL;

	status = CAST(IObject, line1)->GetParent(GetBSTR("Workplane"), &parentWorkplane);
	CHECK_RETURN_STATUS(status)

	IPerpendicular *pPerpendicular = NULL;
	status = (GetCLASS(Perpendicular))->CreatePerpendicular(line1, line2, &pPerpendicular);
	CHECK_RETURN_STATUS(status)

	IConstraint *pConstraint1 = NULL;

	status = CAST(IWorkplane, parentWorkplane)->GetConstraint(CAST(IGeomConstraint, pPerpendicular), &pConstraint1);
	CHECK_RETURN_STATUS(status)

	if(pConstraint1) {
		pPerpendicular->Release();

	}
	else {
			IConstraint *pConstraint = NULL;

			status = activeWorkplane->CreateConstraint(CAST(IGeomConstraint, pPerpendicular), &pConstraint);
			CHECK_RETURN_STATUS(status)
	}

	END_METHOD("MakePerpendicular")
}
